clear;             
tic

eps = 1;

tmin = 0;           
tmax = 10;
timesteps = 20; 
tstep=tmax/timesteps;  
tspan = tmin:tstep:tmax;


xleft = 0;
%xright = 0.9*pi/sqrt(a-a^2);
%xright = 1.1*pi/sqrt(a-a^2);
xright= 1;
xstep=0.01;          %xstep = actual distance of the gridpoints
points = (xright-xleft)/xstep;
xmesh = xleft:xstep:xright;


%if(exist('fc.dat'))
%    load('fc.dat'); %loads the final state of a previous run, see ICbistable further
%else
fc=0;
%end

sol = pdepe(0,@(x,t,u,DuDx) pdeBS(x,t,u,DuDx,eps),@(x) icBS(x,eps,xright,xmesh,fc),@(xl,ul,xr,ur,t) bcBS(xl,ul,xr,ur,t),xmesh,tspan);

toc

plot(xmesh,sol(1,:,1)), axis([xleft xright -xright xright]);
pause;

for j=2:1:timesteps+1                 %plotroutine; the timesteps+1 comes in because sol saves the initial condition at timestep 1! 
   TempU = sol(j,:,1);
   t=j*tstep;
   plot(xmesh,TempU), axis([xleft xright -xright xright]);
   title(t)
   pause(0.1);
end;

save -ascii fc.dat TempU;
